/* Complete USB Joystick Example
   Teensy becomes a USB joystick with 16 or 32 buttons and 6 axis input
   You must select Joystick from the "Tools > USB Type" menu
   Pushbuttons should be connected between the digital pins and ground.
   Potentiometers should be connected to analog inputs 0 to 5.
   This example code is in the public domain.

   Modifikation für antike Fernsteuerungen durch Robert Kränzlein
*/

const int numButtons = 4; 
const int laufzeit = 3;

void setup() {
  Serial.begin(9600);
  Joystick.useManualSend(true);
  pinMode(0, INPUT_PULLUP);     // Knüppel gedrückt?
  pinMode(1, INPUT_PULLUP);     
  pinMode(2, INPUT_PULLUP);     // Ein-Aus Schalter (Kalibrierung)
  pinMode(3, INPUT_PULLUP);     // Knopf (1) für Vollgas/Standgas

  
  Joystick.Z(512);              //unbenutzte Kanäle initialisieren
  Joystick.Zrotate(512);
  Joystick.sliderRight(0);
}

int servoy = 1512;
int servox = 1512;
int speedp = 0;
int gas = 0;
int dauer = 0;
bool buttonp = false;
bool direy = false;
byte allButtons[numButtons];

void loop() {
speedp = analogRead(3)/64;

// Routine für Seitenruder hin- und herschwenkend  
//  if (digitalRead(3) == false) {    //Wenn der Knopf gedrückt ist...
//     if (direy == false) {          //und wenn die Richtung steigend ist..
//        servoy = servoy + speedp;   //Servoposition um Geschwindigkeit erhöhen
//        if (servoy > 2023) {        //Ist das obere Limit überschritten?
//          direy = true;             //...dann Richtung nach unten umkehren
//        }
//     }
//     else {                         //ist aber die Richtung fallend...
//        servoy = servoy - speedp;   //Servopositition um Geschwindigkeit senken
//        if (servoy < 1000) {        //Ist das untere Limit unterschritten?
//          direy = false;            //... dann Richtung nach oben umkehren
//        }
//     }
//  }


// Routine Knopf Gas/Standgas
  if (digitalRead(3) == false) {   //Knopf ist gedrückt
    delay(50);                     //kurz warten
    if (digitalRead(3) == true) {   //warten auf steigende Flanke
       if (gas == 0) {
          gas = 180;               //von Motor aus auf Standgas schalten
          dauer = laufzeit*60*50;  //Timer starten
       }
       else if (gas == 180) {
         gas = 1000;              //Vollgas geben
         Joystick.Y(570);
       }
       else {
         gas = 180;               //von Vollgas zurück wechseln auf Standgas
         Joystick.Y(470);
       }
    }
  }
  if (dauer > 0) {
    dauer = dauer - 1;
    if (dauer < 1023) {
      gas = dauer;
    }
  }
  else {
    gas = 0;  
    Joystick.Y(500);
  }
  Joystick.sliderRight(gas);


//  Routine um über eine zusätzliche Knüppel-Drück-Aktion eine Motorlaufzeit zu starten = Freiflug
//  if (digitalRead(0) == false) {        //Knüppel runtergedrückt = Gas start
//     gas = laufzeit*60*50;                 //Minuten á 60 Sekunden á 50 1/s 
//  }
//
//  if (gas >= 1023) {
//    Joystick.sliderRight(1023);
//  }
//  else {
//    Joystick.sliderRight(gas);
//  }
//  if (gas > 0) {
//    gas = gas - 1;
//  }


// Routine um Knüppel für Seitenruder abzufragen
  if (analogRead(0) <= 440)   {     //Nach rechts lenken...
     servox = servox + speedp;      //Servoposition um Geschwindigkeit erhöhen
        if (servox > 2023) {        //Ist das obere Limit überschritten?
          servox = 2023;            //...dann begrenzen
        }
  }
   else if (analogRead(0) >= 600)   {    //Nach links lenken...
     servox = servox - speedp;      //Servoposition um Geschwindigkeit senken
        if (servox < 1000) {        //Ist das untere Limit unterschritten?
          servox = 1000;            //...dann begrenzen
        }
  }
  else {                            //Ruderhebel neutral
     if (servox > 1500) {
        servox = servox - speedp;   
     }
     else if (servox < 1500) {
        servox = servox + speedp;
     }
  }  
  Joystick.X(servox-1000);



  
  Joystick.sliderLeft(analogRead(3));

  for (int i=0; i<numButtons; i++) {  //alle dititalen Eingänge lesen und Buttons zuordnen
    if (digitalRead(i)) {
      // when a pin reads high, the button is not pressed
      // the pullup resistor creates the "on" signal
      allButtons[i] = 0;
    } else {
      // when a pin reads low, the button is connecting to ground.
      allButtons[i] = 1;
    }
    Joystick.button(i + 1, allButtons[i]);
  }


 
  Joystick.send_now();                  // Übertragung an Joystick
  delay(20);                            //20ms Pause = Ausführung 50x pro Sekunden

  if (digitalRead(2) == false) {        //wenn Schalter EIN dann Aerofly-Kalibrierungsprozess
    Serial.println("aerofly Kalibrierung");
    Serial.println("alles auf Anschlag");
    while (digitalRead(3) == true) {    //Solange Min und Max-Werte abwechselnd senden bis Knopf (1) gedrückt wurde
      Joystick.X(0);
      Joystick.Y(0);
      Joystick.Z(0);
      Joystick.Zrotate(0);
      Joystick.sliderLeft(0);
      Joystick.sliderRight(0);
      for (int i=0; i<numButtons; i++) {  
        Joystick.button(i + 1, 0);
      }
      Joystick.send_now();  
      delay(1000);
      Joystick.X(1023);
      Joystick.Y(1023);
      Joystick.Z(1023);
      Joystick.Zrotate(1023);
      Joystick.sliderLeft(1023);
      Joystick.sliderRight(1023);
      for (int i=0; i<numButtons; i++) {  
        Joystick.button(i + 1, 1);
      }
      Joystick.send_now();  
      delay(600);
    }
    while (digitalRead(3) == false) { 
      delay(10);
    }  
    Serial.println("Nullstellung");     //Solange Mittel-Werte senden bis Knopf (1) gedrückt wurde
    while (digitalRead(3) == true) { 
      Joystick.X(512);
      Joystick.Y(512);
      Joystick.Z(512);
      Joystick.Zrotate(512);
      Joystick.sliderLeft(512);
      Joystick.sliderRight(512);
      for (int i=0; i<numButtons; i++) {  
        Joystick.button(i + 1, 0);
      }
      Joystick.send_now();  
      delay(600);
   


        
    }
    while (digitalRead(2) == false) {    //warten bis Ein-Aus-Schalter wieder zurückgeschaltet wurde
       delay(50);
    }
    gas = 0;
  }
  

}
